/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config.entry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;

public abstract class ConfigEntry<T> {
    protected final ResourceLocation id;
    private final T defaultValue;
    @Nullable
    private T syncedValue;
    private List<Consumer<ResourceLocation>> listeners = List.of();

    public ConfigEntry(ResourceLocation id, T defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public T syncedValue() {
        return this.syncedValue;
    }

    public boolean isSynced() {
        return this.syncedValue != null;
    }

    public void setSyncedValue(@Nullable T value) {
        this.syncedValue = value;
    }

    public T convertValue(Object value) {
        return (T)value;
    }

    public abstract boolean isValidValue(Object var1);

    public abstract OptionValue<?> createUI(OptionsList var1, String var2, IPluginConfig var3, BiConsumer<ResourceLocation, Object> var4);

    public void addListener(Consumer<ResourceLocation> listener) {
        if (this.listeners.isEmpty()) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void notifyChange() {
        for (Consumer<ResourceLocation> listener : this.listeners) {
            listener.accept(this.id);
        }
    }
}

